/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4j;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import org.das2.util.LoggerManager;
import org.fuin.utils4j.PropertiesFile;

public final class PropertiesFilePreferences
extends AbstractPreferences {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.dom.options");
    public static final String FILENAME = "preferences.properties";
    private final File dir;
    private final PropertiesFile file;
    private boolean removed;

    public PropertiesFilePreferences(File dir) {
        this(null, dir, "");
    }

    public PropertiesFilePreferences(File dir, String propFileName) {
        this(null, dir, "", propFileName);
    }

    public PropertiesFilePreferences(PropertiesFilePreferences parent, File dir) {
        this(parent, dir, dir.getName(), FILENAME);
    }

    private PropertiesFilePreferences(PropertiesFilePreferences parent, File dir, String name) {
        this(parent, dir, name, FILENAME);
    }

    private PropertiesFilePreferences(PropertiesFilePreferences parent, File dir, String name, String propertiesFileName) {
        super(parent, name);
        this.dir = dir;
        File propertiesFile = new File(dir, propertiesFileName);
        if (!propertiesFile.exists()) {
            if (!propertiesFile.getParentFile().canWrite()) {
                logger.log(Level.FINE, "unable to write prefs file at {0}", propertiesFile);
            } else {
                logger.log(Level.FINE, "creating prefs file at {0}", propertiesFile);
            }
        }
        this.file = new PropertiesFile(propertiesFile);
        this.removed = false;
    }

    @Override
    protected final AbstractPreferences childSpi(String name) {
        File childDir = new File(this.dir, name);
        return new PropertiesFilePreferences(this, childDir, name);
    }

    @Override
    protected final String[] childrenNamesSpi() throws BackingStoreException {
        try {
            ArrayList<String> childs = new ArrayList<String>();
            File[] files = this.dir.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].isDirectory()) continue;
                    childs.add(files[i].getName());
                }
            }
            return childs.toArray(new String[0]);
        }
        catch (RuntimeException ex) {
            throw new BackingStoreException(ex);
        }
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
        try {
            if (this.removed) {
                this.file.delete();
                this.dir.delete();
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String[] comments = new String[]{"Do not edit, as this is a copy of properties during migration.", "See https://sourceforge.net/p/autoplot/bugs/2175/", "Created by " + this.getClass().getName(), sdf.format(new Date())};
                this.mkdirIfNecessary();
                this.file.save(comments, true);
            }
        }
        catch (Exception ex) {
            throw new BackingStoreException(ex);
        }
    }

    private void mkdirIfNecessary() throws BackingStoreException {
        if (!this.dir.exists() && !this.dir.mkdirs()) {
            throw new BackingStoreException("Failed to create directory '" + this.dir + "'!");
        }
    }

    @Override
    protected final String getSpi(String key) {
        this.loadIfNecessary();
        return this.file.get(key);
    }

    @Override
    protected final String[] keysSpi() throws BackingStoreException {
        this.loadIfNecessary();
        return this.file.getKeyArray();
    }

    @Override
    protected final void putSpi(String key, String value) {
        this.loadIfNecessary();
        this.file.put(key, value);
    }

    @Override
    protected final void removeNodeSpi() throws BackingStoreException {
        this.file.clear();
        this.removed = true;
    }

    @Override
    protected final void removeSpi(String key) {
        this.loadIfNecessary();
        this.file.remove(key);
    }

    private void loadIfNecessary() {
        if (!this.file.isLoaded()) {
            try {
                this.syncSpi();
            }
            catch (BackingStoreException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    protected final void syncSpi() throws BackingStoreException {
        if (this.dir.exists() && this.file.exists()) {
            try {
                this.file.load();
            }
            catch (Exception ex) {
                throw new BackingStoreException(ex);
            }
        }
    }

    public final Properties toProperties() {
        return this.file.toProperties();
    }
}

